<?php

header("X-Content-Type-Options: nosniff");
header("X-XSS-Protection: 1; mode=block");
// header("X-Frame-Options: DENY");
header('Expires: Sun, 01 Jan 2000 00:00:00 GMT');
header('Cache-Control: no-store, no-cache, must-revalidate');
header('Cache-Control: post-check=0, pre-check=0', FALSE);
header('Pragma: no-cache');

ini_set('session.cookie_httponly', 'on');
ini_set('session.cookie_secure', 'on');

session_name("DIGIMAXOTOORDER");
session_start();

include "common/config/config.php";
include "common/config/dbconfig.php";
include "common/functions/funcconnect.php";
include "common/functions/funcvalidateinput.php";
openDB();

$voltadata=isset($_POST['volta']) ? cleanval($_POST['volta']) : NULL;
$voltadecode=base64_decode($voltadata);
$_VOLTA=json_decode($voltadecode, true);

// echo $voltadata; 
// var_dump($_VOLTA);

// data pesanan dari partner
$pid=isset($_VOLTA['pid']) ? cleanval($_VOLTA['pid']) : NULL;
$mid=isset($_VOLTA['mid']) ? cleanval($_VOLTA['mid']) : NULL;
$mname=isset($_VOLTA['mname']) ? cleanval($_VOLTA['mname']) : NULL;
$mcontact=isset($_VOLTA['mcontact']) ? cleanval($_VOLTA['mcontact']) : NULL;
$mphone=isset($_VOLTA['mphone']) ? cleanval($_VOLTA['mphone']) : NULL;
$auth=isset($_VOLTA['auth']) ? cleanval($_VOLTA['auth']) : NULL;

$oid=isset($_POST['oid']) ? cleanval($_POST['oid']) : NULL; // id transaksi
$rt=isset($_POST['rt']) ? cleanval($_POST['rt']) : NULL; // request time, format: yyyy-mm-dd hh:ii:ss
$namalengkap=isset($_POST['namalengkap']) ? cleanval($_POST['namalengkap']) : NULL; // nama lengkap pemesan sesuai ktp
$alamattinggal=isset($_POST['alamattinggal']) ? cleanval($_POST['alamattinggal']) : NULL; // alamat tinggal sesuai ktp
$nohandphone=isset($_POST['nohandphone']) ? cleanval($_POST['nohandphone']) : NULL; // nomor handphone pemesan
$noktp=isset($_POST['noktp']) ? cleanval($_POST['noktp']) : NULL; // nomor ktp pemesan, bisa berbeda dengan nomor ktp bpkb / stnk
$filektp=isset($_FILES['filektp']) ? $_FILES['filektp'] : NULL; // foto ktp pemesan
$carabayar=isset($_POST['carabayar']) ? cleanval($_POST['carabayar']) : NULL; // cara bayar (tunai / cicilan)
$email=isset($_POST['email']) ? cleanval($_POST['email']) : NULL; // alamat email pemesan
$kodevoucher=isset($_POST['kodevoucher']) ? cleanval($_POST['kodevoucher']) : NULL; // kode voucher diskon
$catatan=isset($_POST['catatan']) ? cleanval($_POST['catatan']) : NULL; // catatan tambahan
$masalah=NULL;
$errmsg=NULL;

// echo $_SESSION['ordersession']."<br>";
// echo $pid."<br>";
// echo $mid."<br>";
// echo $oid."<br>";
// echo $rt."<br>";
// echo $namalengkap."<br>";
// echo $alamattinggal."<br>";
// echo $nohandphone."<br>";
// echo $noktp."<br>";
// echo $rt."<br>";
// echo $filektp['tmp_name']."<br>";
// echo $carabayar."<br>";
// echo $email."<br>";

if (!empty($_SESSION['ordersession']) && !empty($pid) && !empty($mid) && !empty($oid) && !empty($rt) && !empty($namalengkap) && !empty($alamattinggal) && !empty($nohandphone) && !empty($noktp) && !empty($_FILES['filektp']['tmp_name']) && !empty($carabayar) && !empty($email))
{	// ambil idrekanan
		$qir="SELECT idrekanan
								FROM $db_rekanan
								WHERE pid='".$pid."'
														AND statussuspend='0'
														AND statusnonaktif='0'
								";
		$rir=mysqli_query($dbConnection, $qir);
		if (mysqli_num_rows($rir)>0)
		{ $dir=mysqli_fetch_array($rir);
				$idrekanan=$dir['idrekanan'];
				}
		else
		{ $masalah=1;
				$errmsg="Maaf, proses pemesanan ".$oid." tidak dapat dilanjutkan.<br><br>
													Rekanan penjualan tidak sah atau sudah tidak aktif.
													";
				}
		
		if (empty($masalah))
		{ // ambil idtoko
				$qit="SELECT idtoko
										FROM $db_toko
										WHERE mid='".$mid."'
																AND statusnonaktif='0'
										";
				$rit=mysqli_query($dbConnection, $qit);
				if (mysqli_num_rows($rit)>0)
				{ $dit=mysqli_fetch_array($rit);
						$idtoko=$dit['idtoko'];
						}
				else
				{ $masalah=1;
						$errmsg="Maaf, proses pemesanan ".$oid." tidak dapat dilanjutkan.<br><br>
															Rekanan penjualan tidak sah atau sudah tidak aktif.
															";
						}
				}
		
		if (empty($masalah))
		{ // cek nomor order
				$oidqc=substr($_SESSION['ordersession'], 0, 12);
				if ($oid==$oidqc)
				{	$qip="SELECT idpesanan
												FROM $db_pesanan
												WHERE nomorpesanan='".$oid."'
																		AND statusorder IS NULL
												";
						$rip=mysqli_query($dbConnection, $qip);
						if (mysqli_num_rows($rip)>0)
						{ $dip=mysqli_fetch_array($rip);
								$idpesanan=$dip['idpesanan'];
								}
						else
						{ $masalah=1;
								$errmsg="Maaf, proses pemesanan ".$oid." tidak dapat dilanjutkan.<br><br>
																	Silakan klik tombol di bawah ini untuk mengulang.<br><br>
																	<input type='button' value=' HALAMAN SEBELUMNYA ' style='color:#000000; width:100%; padding:10px 15px 10px 15px; -webkit-appearance:none; -webkit-border-radius:0px; border:1px solid #acbccc; background-color:#efefef; cursor:pointer' onclick=\"history.back(-1)\">
																	";
								}
						}
				else
				{ 
						}					
				}
		
		// validasi nilai yang diberikan
		if (empty($masalah))
		{ if (empty($namalengkap))
				{ $masalah=1;
						$errmsg="Anda harus memasukan nama lengkap untuk melakukan pemesanan.<br><br>
															Silakan klik tombol di bawah ini untuk mengulang.<br><br>
															<input type='button' value=' HALAMAN SEBELUMNYA ' style='color:#000000; width:100%; padding:10px 15px 10px 15px; -webkit-appearance:none; -webkit-border-radius:0px; border:1px solid #acbccc; background-color:#efefef; cursor:pointer' onclick=\"history.back(-1)\">
															";
						}
				else if (!nameval($namalengkap))
				{ $masalah=1;
						$errmsg="Nama lengkap yang diberikan tidak umum: ".$namalengkap."<br><br>
															Nama hanya boleh berupa huruf dan spasi, tanpa angka dan simbol.
															Silakan klik tombol di bawah ini untuk mengulang.<br><br>
															<input type='button' value=' HALAMAN SEBELUMNYA ' style='color:#000000; width:100%; padding:10px 15px 10px 15px; -webkit-appearance:none; -webkit-border-radius:0px; border:1px solid #acbccc; background-color:#efefef; cursor:pointer' onclick=\"history.back(-1)\">
															";
						}
				else if (empty($alamattinggal))
				{ $masalah=1;
						$errmsg="Anda harus memasukan alamat tinggal untuk melakukan pemesanan.<br><br>
															Silakan klik tombol di bawah ini untuk mengulang.<br><br>
															<input type='button' value=' HALAMAN SEBELUMNYA ' style='color:#000000; width:100%; padding:10px 15px 10px 15px; -webkit-appearance:none; -webkit-border-radius:0px; border:1px solid #acbccc; background-color:#efefef; cursor:pointer' onclick=\"history.back(-1)\">
															";
						}
				else if (empty($nohandphone))
				{ $masalah=1;
						$errmsg="Anda harus memasukan nomor handphone untuk melakukan pemesanan.<br><br>
															Silakan klik tombol di bawah ini untuk mengulang.<br><br>
															<input type='button' value=' HALAMAN SEBELUMNYA ' style='color:#000000; width:100%; padding:10px 15px 10px 15px; -webkit-appearance:none; -webkit-border-radius:0px; border:1px solid #acbccc; background-color:#efefef; cursor:pointer' onclick=\"history.back(-1)\">
															";
						}
				else if (!is_int($nohandphone) && strlen($nohandphone)<11 && strlen($nohandphone)>13 && substr($nohandphone, 0, 3)!="081")
				{ $masalah=1;
						$errmsg="No. handphone yang diberikan tidak sah: ".$nohandphone."<br><br>
															Mohon berikan nomor handphone Anda yang benar dan aktif (contoh: 081xxxxxxx).
															Silakan klik tombol di bawah ini untuk mengulang.<br><br>
															<input type='button' value=' HALAMAN SEBELUMNYA ' style='color:#000000; width:100%; padding:10px 15px 10px 15px; -webkit-appearance:none; -webkit-border-radius:0px; border:1px solid #acbccc; background-color:#efefef; cursor:pointer' onclick=\"history.back(-1)\">
															";
						}
				else if (empty($noktp))
				{ $masalah=1;
						$errmsg="Anda harus memasukan nomor KTP untuk melakukan pemesanan.<br><br>
															Silakan klik tombol di bawah ini untuk mengulang.<br><br>
															<input type='button' value=' HALAMAN SEBELUMNYA ' style='color:#000000; width:100%; padding:10px 15px 10px 15px; -webkit-appearance:none; -webkit-border-radius:0px; border:1px solid #acbccc; background-color:#efefef; cursor:pointer' onclick=\"history.back(-1)\">
															";
						}
				else if (!is_int($noktp) && strlen($noktp)!=16)
				{ $masalah=1;
						$errmsg="No. KTP yang diberikan tidak sah: ".$noktp."<br><br>
															Silakan klik tombol di bawah ini untuk mengulang.<br><br>
															<input type='button' value=' HALAMAN SEBELUMNYA ' style='color:#000000; width:100%; padding:10px 15px 10px 15px; -webkit-appearance:none; -webkit-border-radius:0px; border:1px solid #acbccc; background-color:#efefef; cursor:pointer' onclick=\"history.back(-1)\">
															";
						}
				else if (empty($filektp['tmp_name']))
				{ $masalah=1;
						$errmsg="Anda harus mengunduh foto KTP untuk melakukan pemesanan.<br><br>
															Silakan klik tombol di bawah ini untuk mengulang.<br><br>
															<input type='button' value=' HALAMAN SEBELUMNYA ' style='color:#000000; width:100%; padding:10px 15px 10px 15px; -webkit-appearance:none; -webkit-border-radius:0px; border:1px solid #acbccc; background-color:#efefef; cursor:pointer' onclick=\"history.back(-1)\">
															";
						}
				else if ($filektp['type']!="image/gif" && $filektp['type']!="image/jpeg" && $filektp['type']!="image/jpg" && $filektp['type']!="image/png")
				{ $masalah=1;
						$errmsg="Foto KTP harus dalam format JPG, GIF, PNG.<br><br>
															Silakan klik tombol di bawah ini untuk mengulang.<br><br>
															<input type='button' value=' HALAMAN SEBELUMNYA ' style='color:#000000; width:100%; padding:10px 15px 10px 15px; -webkit-appearance:none; -webkit-border-radius:0px; border:1px solid #acbccc; background-color:#efefef; cursor:pointer' onclick=\"history.back(-1)\">
															";
						}
				else if (empty($email))
				{ $masalah=1;
						$errmsg="Anda harus memasukan alamat email untuk melakukan pemesanan.<br><br>
															Silakan klik tombol di bawah ini untuk mengulang.<br><br>
															<input type='button' value=' HALAMAN SEBELUMNYA ' style='color:#000000; width:100%; padding:10px 15px 10px 15px; -webkit-appearance:none; -webkit-border-radius:0px; border:1px solid #acbccc; background-color:#efefef; cursor:pointer' onclick=\"history.back(-1)\">
															";
						}
				else if (!emailval($email))
				{ $masalah=1;
						$errmsg="Alamat e-mail yang diberikan tidak umum: ".$email."<br><br>
															Mohon berikan alamat email Anda yang benar dan aktif.
															Silakan klik tombol di bawah ini untuk mengulang.<br><br>
															<input type='button' value=' HALAMAN SEBELUMNYA ' style='color:#000000; width:100%; padding:10px 15px 10px 15px; -webkit-appearance:none; -webkit-border-radius:0px; border:1px solid #acbccc; background-color:#efefef; cursor:pointer' onclick=\"history.back(-1)\">
															";
						}
				else if (empty($carabayar))
				{ $masalah=1;
						$errmsg="Anda harus memilih salah satu cara pembayaran pelunasan pesanan.<br><br>
															Silakan klik tombol di bawah ini untuk mengulang.<br><br>
															<input type='button' value=' HALAMAN SEBELUMNYA ' style='color:#000000; width:100%; padding:10px 15px 10px 15px; -webkit-appearance:none; -webkit-border-radius:0px; border:1px solid #acbccc; background-color:#efefef; cursor:pointer' onclick=\"history.back(-1)\">
															";
						}
				}
		
		// echo "Masalah: ".$masalah."<br>";
		if (empty($masalah))
		{ /*
				// cek kode voucher untuk diskon
				$diskongagal=NULL;
				$pesangagal=NULL;
				if (!empty($kodevoucher))
				{ $qcv="SELECT *
												FROM $db_voucher
												WHERE kodevoucher='".$kodevoucher."'
																		AND mulaiberlaku<='".$tglhariini."'
																		AND selesaiberlaku>='".$tglhariini."'
												";
						$rcv=mysqli_query($dbConnection, $qcv);
						if (mysqli_num_rows($rcv)>0)
						{ $dcv=mysqli_fetch_array($rcv);
								if (!empty($dcv['idrekanan']) && $dcv['idrekanan']==$idrekanan)
								{ $diskongagal=1;
										$pesangagal="Kode voucher yang diberikan tidak sah.<br><br>";
										}
								if (!empty($dcv['iditem']))
								{ // ambil nama item
										$qip="SELECT a.iditem,
																							b.kodekategoribarang, b.namakategoribarang,
																							c.kodemerek, c.namamerek,
																							d.kodemodel, d.namamodel,
																							e.kodewarna, e.namawarna, e.kodehtml,
																							f.thnproduksi,
																							g.iditemprice, g.ontheroad, g.hargajual,
																							h.namawilayahotr
																FROM $db_item a
																INNER JOIN $db_kategoribarang b ON a.idkategoribarang=b.idkategoribarang
																INNER JOIN $db_merek c ON a.idmerek=c.idmerek
																INNER JOIN $db_model d ON a.idmodel=d.idmodel
																INNER JOIN $db_warna e ON a.idwarna=e.idwarna
																INNER JOIN $db_thnproduksi f ON a.idthnproduksi=f.idthnproduksi
																INNER JOIN $db_itemprice g ON d.idmodel=g.idmodel
																INNER JOIN $db_wilayahotr h ON g.idwilayahotr=h.idwilayahotr
																WHERE a.iditem='".$dcv['iditem']."'
																						AND a.tersedia='1'
																						AND b.tersedia='1'
																						AND c.tersedia='1'
																						AND d.tersedia='1'
																						AND f.tersedia='1'
																						AND g.iditemprice='".$itemdata[2]."'
																ORDER BY a.iditem,
																										b.idkategoribarang, 
																										c.idmerek, 
																										d.idmodel, 
																										g.idwilayahotr,
																										f.idthnproduksi,
																										e.namawarna
																										ASC
																	";
										$rip=mysqli_query($dbConnection, $qip);
										$dip=mysqli_
										// ambil item yang dipesan
										$qod="SELECT iditem, 
																							jumlahpesan
																FROM $db_pesanandetail
																WHERE idrekanan='".$pid."'
																						AND idtoko='".$mid."'
																						AND nomorpesanan='".$oid."'
																						AND sesipesanan='".$_SESSION['ordersession']."'
																";
										$rod=mysqli_query($dbConnection, $qod);
										if (mysqli_num_rows($rod)>0)
										{ while($dod=mysqli_fetch_array($rod))
												{ 
														}
												}
										else
										{ $diskongagal=1;
												$pesangagal="Kode voucher hanya berlaku untuk produk.<br><br>";
												}
										}
								}
						else
						{ $diskongagal=1;
								$pesangagal="Kode voucher tidak sah atau kadaluwarsa.<br><br>";
								}							
						}
				*/
				
				// simpan file ktp
				$ktpextension=end(explode(".", $filektp['name']));
				$ktpfilename=date("YmdHis").strtoupper($oid).".".$ktpextension;
				$filepath="images/ktpfile/".$ktpfilename;
				move_uploaded_file($filektp['tmp_name'], $filepath);

				// masukan data pesanan
				$qip="UPDATE $db_pesanan
										SET kodevoucher='".$kodevoucher."',
														namalengkap='".$namalengkap."',
														noktp='".$noktp."',
														fotoktp='".$ktpfilename."',
														alamatlengkap='".$alamattinggal."',
														nohandphone='".$nohandphone."',
														email='".$email."',
														idcarabayarlunas='".$carabayar."',
														catatan='".$catatan."'
										WHERE idrekanan='".$idrekanan."'
																AND idtoko='".$idtoko."'
																AND nomorpesanan='".$oid."'
																AND sesipesanan='".$_SESSION['ordersession']."'
																AND waktupesanan='".$rt."'
										";
				$rip=mysqli_query($dbConnection, $qip);
				// echo $qip."<br>".mysqli_error($dbConnection)."<br><br>";
				if ($rip)
				{ // ambil jumlah pesanan
						$qdp="SELECT SUM(jumlahpesan) AS totalqty
												FROM $db_pesanandetail
												WHERE idrekanan='".$idrekanan."'
																		AND idtoko='".$idtoko."'
																		AND nomorpesanan='".$oid."'
																		AND sesipesanan='".$_SESSION['ordersession']."'
												GROUP BY sesipesanan
												";
						$rdp=mysqli_query($dbConnection, $qdp);
						$ddp=mysqli_fetch_array($rdp);
						$totalqty=$ddp['totalqty'];
						
						// ambil nilai dp
						$qnd="SELECT jumlahnilaidp
												FROM $db_nilaidp
												";
						$rnd=mysqli_query($dbConnection, $qnd);
						$dnd=mysqli_fetch_array($rnd);
						$totaltandajadi=$dnd['jumlahnilaidp']*$totalqty;
						
						// masukan nilai tanda jadi
						$qtj="UPDATE $db_pesanan
												SET totaltandajadi='".$totaltandajadi."'
												WHERE idrekanan='".$idrekanan."'
																		AND idtoko='".$idtoko."'
																		AND nomorpesanan='".$oid."'
																		AND sesipesanan='".$_SESSION['ordersession']."'
																		AND waktupesanan='".$rt."'
												";
						$rtj=mysqli_query($dbConnection, $qtj);
						// echo $qtj."<br>".mysqli_error($dbConnection)."<br><br>";
						
						/*
						// pembayaran tanda jadi
						$qmb="SELECT *
												FROM $db_carabayartandajadi
												WHERE aktif='1'
												ORDER BY urutan ASC
												";
						$rmb=mysqli_query($dbConnection, $qmb);
						if (mysqli_num_rows($rmb)>0)
						{ $metodebayar="";
								while($dmb=mysqli_fetch_array($rmb))
								{ if (!empty($metodebayar))
										{ $metodebayar.="<br><br>";
												}
										$metodebayar.="&nbsp; <input type='radio' name='carabayardp' value='".$dmb['idcarabayartandajadi']."' style='padding:0; margin:0; vertical-align:middle; cursor:pointer'> &nbsp; ".$dmb['namacarabayartandajadi'];
										}
								}
						else
						{ $metodebayar="Maaf, belum ada metode pembayaran yang tersedia.";
								}							
						*/
						
						$content="<form id='payorder' method='post' action='order_payment.php'>
																	<input type='hidden' name='volta' value='".$voltadata."'>
																	<input type='hidden' name='oid' value='".$oid."'>
																	<input type='hidden' name='rt' value='".$rt."'>
																	<input type='hidden' name='totalqty' value='".$totalqty."'>
																	<input type='hidden' name='totaltandajadi' value='".$totaltandajadi."'>
																	<table border='0' cellpadding='0' cellspacing='0' width='100%' style='border:1px solid #efefef'>
																		<tr>
																			<td align='center' valign='middle' width='100%' style='background-color:efefef; padding:10px'>
																				<b>PEMBAYARAN TANDA JADI</b>
																			</td>
																		</tr>
																		<tr>
																			<td align='left' valign='top' width='100%' style='padding:10px'>
																				<b>Jumlah tanda jadi yang dibayarkan adalah sebesar Rp. ".number_format($dnd['jumlahnilaidp'], 0, ",", ".")." <u>per unit</u>.</b><br><br>
																				Jumlah Pesanan:<br>".$totalqty." &nbsp;Unit<br><br>
																				Total Tanda Jadi:<br>Rp. ".number_format($totaltandajadi, 0, ",", ".")."<br><br>
																				<hr><br>
																			</td>
																		</tr>
																		<tr>
																			<td align='left' valign='middle' style='padding:10px'>
																				<input id='paybutton' type='submit' value=' BAYAR TANDA JADI SEKARANG ' style='color:#000000; width:100%; padding:10px 15px 10px 15px; -webkit-appearance:none; -webkit-border-radius:0px; border:1px solid #acbccc; background-color:#efefef; cursor:pointer' onclick=\"document.getElementById('paybutton').disabled=true; this.value='PERMINTAAN SEDANG DIPROSES...'; document.getElementById('payorder').submit();\">
																			</td>
																		</tr>
																	<table>
																</form>	
																";
						}
				else
				{ $content="<table border='0' cellpadding='0' cellspacing='0' width='100%' style='border:1px solid #efefef'>
																	<tr>
																		<td align='center' valign='middle' width='100%' style='background-color:efefef; padding:10px'>
																			<b>PESANAN BERMASALAH</b>
																		</td>
																	</tr>
																	<tr>
																		<td align='left' valign='top' width='100%' style='padding:10px'>
																			Maaf, proses pemesanan tidak dapat dilanjutkan.<br><br>
																			Server saat ini sedang dalam kondisi sibuk. Mohon tunggu beberapa saat dan coba kembali.<br><br>
																			Hubungi layanan konsumen kami dan berikan kode log pesanan di bawah ini jika proses pemesanan masih bermasalah.<br><br>
																			".$_SESSION['ordersession']."
																		</td>
																	</tr>
																<table>
																";
						}					
				}
		else
		{ $content="<table border='0' cellpadding='0' cellspacing='0' width='100%' style='border:1px solid #efefef'>
															<tr>
																<td align='center' valign='middle' width='100%' style='background-color:efefef; padding:10px'>
																	<b>PESANAN BERMASALAH</b>
																</td>
															</tr>
															<tr>
																<td align='left' valign='top' width='100%' style='padding:10px'>
																	".$errmsg."
																</td>
															</tr>
														<table>
														";
				}
		}
else
{ $content="<table border='0' cellpadding='0' cellspacing='0' width='100%' style='border:1px solid #efefef'>
													<tr>
														<td align='center' valign='middle' width='100%' style='background-color:efefef; padding:10px'>
															<b>PESANAN BERMASALAH</b>
														</td>
													</tr>
													<tr>
														<td align='left' valign='top' width='100%' style='padding:10px'>
															Maaf, semua data harus diisi.<br><br>
															Silakan klik tombol di bawah ini untuk melengkapi data yang diperlukan.<br><br>
															<input type='button' value=' HALAMAN SEBELUMNYA ' style='color:#000000; width:100%; padding:10px 15px 10px 15px; -webkit-appearance:none; -webkit-border-radius:0px; border:1px solid #acbccc; background-color:#efefef; cursor:pointer' onclick=\"history.back(-1)\">
														</td>
													</tr>
												<table>
												";
		}

closeDB();

include "common/include/template.php";
$temp=new template;
$temp->define_theme("themes/theme1.html");
$temp->define_tag("{PAGETITLE}", $namaaplikasi);
$temp->define_tag("{APPCONTENT}", $content);
$temp->parse();
$temp->printproses();

?>