<?php

header("X-Content-Type-Options: nosniff");
header("X-XSS-Protection: 1; mode=block");
header("X-Frame-Options: DENY");
header('Expires: Sun, 01 Jan 2000 00:00:00 GMT');
header('Cache-Control: no-store, no-cache, must-revalidate');
header('Cache-Control: post-check=0, pre-check=0', FALSE);
header('Pragma: no-cache');

ini_set('session.cookie_httponly', 'on');
ini_set('session.cookie_secure', 'on');

session_name("SIGNADMAUTH");
session_start();

include "common/config/config.php";
include "common/config/dbconfig.php";
include "common/functions/funcconnect.php";
include "common/functions/funcvalidateinput.php";
include "common/functions/funcauthen.php";
openDB();

if (!authen())
{ header ("location: login.php");
		}
else
{ $idpesanan=isset($_GET['idp']) ? cleanval($_GET['idp']) : NULL;
		$nomorpesanan=isset($_GET['oid']) ? base64_decode(cleanval($_GET['oid'])) : NULL;
		$qord="SELECT *
									FROM $db_pesanan
									WHERE idpesanan='".$idpesanan."'
															AND nomorpesanan='".$nomorpesanan."'
									";
		$rord=mysqli_query($dbConnection, $qord);
		if (mysqli_num_rows($rord)>0)
		{ $dord=mysqli_fetch_array($rord);

				// status terakhir
				if ($dord['statusorder']==1)
				{ $statusterakhir="Bayar Tanda Jadi (".date("d M Y H:i:s", strtotime($dord['waktutandajadi'])).")";
						}
				else if ($dord['statusorder']==2)
				{ $statusterakhir="Pemeriksaan Data";
						}
				else if ($dord['statusorder']==3)
				{ $statusterakhir="Pembayaran Lunas";
						}
				else if ($dord['statusorder']==4)
				{ $statusterakhir="Pengajuan Faktur";
						}
				else if ($dord['statusorder']==5)
				{ $statusterakhir="Pengiriman";
						}
				else if ($dord['statusorder']==6)
				{ $statusterakhir="BPKB Selesai";
						}
				else if ($dord['statusorder']==7)
				{ $statusterakhir="STNK Selesai";
						}
				else if ($dord['statusorder']==8)
				{ $statusterakhir="Pesanan Batal";
						}

				// catatan semua proses
				$qcp="SELECT * 
										FROM $db_pesanannote
										WHERE nomorpesanan='".$dord['nomorpesanan']."'
																AND sesipesanan='".$dord['sesipesanan']."'
										ORDER BY catattgl DESC
										";
				$rcp=mysqli_query($dbConnection, $qcp);
				if (mysqli_num_rows($rcp)>0)
				{ $catatan="";
						while ($dcp=mysqli_fetch_array($rcp))
						{ $catatan.="<b>".date("d M Y H:i:s", strtotime($dcp['catattgl']))." - ".$dcp['catatoleh']."</b><br>".str_replace("\n", "", $dcp['catatan'])."<br><br>";
								}
						}
				else
				{ $catatan="(Belum ada catatan)";
						}
				
				// pembayaran
				$qcb="SELECT *
										FROM $db_carabayartandajadi
										WHERE idcarabayartandajadi='".$dord['idcarabayartandajadi']."'
										";
				$rcb=mysqli_query($dbConnection, $qcb);
				$dcb=mysqli_fetch_array($rcb);
				$datapembayaran="TANDA JADI IDR ".number_format($dord['totaltandajadi'], 0, ",", ".")." PADA TANGGAL ".date("d M Y H:i:s", strtotime($dord['waktutandajadi']))." MENGGUNAKAN ".$dcb['namacarabayartandajadi'];
				$qbl="SELECT *
										FROM $db_lunasbayar
										WHERE nomorpesanan='".$dord['nomorpesanan']."'
																AND sesipesanan='".$dord['sesipesanan']."'
										";
				$rbl=mysqli_query($dbConnection, $qbl);
				if (mysqli_num_rows($rbl)>0)
				{ $dbl=mysqli_fetch_array($rbl);
						$datapembayaran.="PELUNASAN IDR ".number_format($dbl['jumlahpelunasan'], 0, ",", ".")." PADA TANGGAL ".date("d M Y H:i:s", strtotime($dbl['tglpelunasan']))." DIKONFIRMASI OLEH ".$dbl['userpelunasan'];
						if (!empty($dbl['catatanpelunasan']))
						{ $datapembayaran.="<br>Catatan: ".$dbl['catatanpelunasan'];
								}
						}
				// data produk yang dibeli
				$qoi="SELECT a.iditem,
																	b.kodekategoribarang, b.namakategoribarang,
																	c.kodemerek, c.namamerek,
																	d.kodemodel, d.namamodel,
																	e.kodewarna, e.namawarna, e.kodehtml,
																	f.thnproduksi,
																	g.iditemprice, g.ontheroad,
																	h.namawilayahotr,
																	i.*
										FROM $db_pesanandetail i
										INNER JOIN $db_item a ON i.iditem=a.iditem
										INNER JOIN $db_kategoribarang b ON a.idkategoribarang=b.idkategoribarang
										INNER JOIN $db_merek c ON a.idmerek=c.idmerek
										INNER JOIN $db_model d ON a.idmodel=d.idmodel
										INNER JOIN $db_warna e ON a.idwarna=e.idwarna
										INNER JOIN $db_thnproduksi f ON a.idthnproduksi=f.idthnproduksi
										INNER JOIN $db_itemprice g ON d.idmodel=g.idmodel AND i.iditemprice=g.iditemprice
										INNER JOIN $db_wilayahotr h ON g.idwilayahotr=h.idwilayahotr
										WHERE i.nomorpesanan='".$dord['nomorpesanan']."'
																AND i.sesipesanan='".$dord['sesipesanan']."'
										ORDER BY i.idpesanandetail DESC
										";
				$roi=mysqli_query($dbConnection, $qoi);
				// echo $qoi."<br><br>".mysqli_error($dbConnection)."<br><br>";
				// exit;
				$dataproduk="";
				while ($doi=mysqli_fetch_array($roi))
				{ if (empty($doi['ontheroad']))
						{ $ontrharga="OFF-THE-ROAD ";
								}
						else
						{ $ontrharga="ON-THE-ROAD ";
								}
						if (!empty($dataproduk))
						{ $dataproduk.="<br><br>";
								}
						$dataproduk.=$doi['jumlahpesan']." UNIT ".strtoupper($doi['namamerek'])." ".strtoupper($doi['namamodel'])." ".strtoupper($doi['namawarna'])." THN ".$doi['thnproduksi']."
																			".$ontrharga." ".strtoupper($doi['namawilayahotr'])." HARGA JUAL IDR ".number_format($doi['hargajual'], 0, ",", ".")."	DISKON IDR ".number_format($doi['jumlahdiskon'], 0, ",", ".");
						}
				
				$qcb="SELECT *
										FROM $db_carabayarlunas
										WHERE idcarabayarlunas='".$dord['idcarabayarlunas']."'
										";
				$rcb=mysqli_query($dbConnection, $qcb);
				$dcb=mysqli_fetch_array($rcb);
				$datapesanan="<table border='0' cellspacing='0' cellpadding='0' width='100%'>
																			<tr>
																				<td align='left' valign='middle' width='100%' style='line-height:17px; padding-bottom:10px'>
																					<b>Nama Lengkap</b><br>
																					".strtoupper($dord['namalengkap'])."
																				</td>	
																			</tr>
																			<tr>
																				<td align='left' valign='middle' width='100%' style='line-height:17px; padding-bottom:10px'>
																					<b>Alamat Lengkap</b><br>
																					".strtoupper($dord['alamatlengkap'])."
																				</td>	
																			</tr>
																			<tr>
																				<td align='left' valign='middle' width='100%' style='line-height:17px; padding-bottom:10px'>
																					<b>No. Handphone</b><br>
																					".$dord['nohandphone']."
																				</td>	
																			</tr>
																			<tr>
																				<td align='left' valign='middle' width='100%' style='line-height:17px; padding-bottom:10px'>
																					<b>No. KTP</b><br>
																					".$dord['noktp']."<br>
																					<img src='https://api.digimaxoto.com/order/images/ktpfile/".$dord['fotoktp']."' style='width:300px; border:1px solid #acbccc; padding:1px; border-radius:10px'>
																				</td>	
																			</tr>
																			<tr>
																				<td align='left' valign='middle' width='100%' style='line-height:17px; padding-bottom:10px'>
																					<b>Alamat E-mail</b><br>
																					".$dord['email']."
																				</td>	
																			</tr>
																			<tr>
																				<td align='left' valign='middle' width='100%' style='line-height:17px; padding-bottom:10px'>
																					<b>Pelunasan Pembayaran</b><br>
																					".strtoupper($dcb['jenispembayaranlunas'])."
																				</td>	
																			</tr>
																			<tr>
																				<td align='left' valign='middle' width='100%' style='line-height:17px; padding-bottom:10px'>
																					<b>Voucher Diskon</b><br>
																					".strtoupper($dord['kodevoucher'])."
																				</td>	
																			</tr>
																			<tr>
																				<td align='left' valign='middle' width='100%' style='line-height:17px; padding-bottom:10px'>
																					<b>Catatan Pesanan</b><br>
																					".strtoupper($dord['catatan'])."
																				</td>	
																			</tr>
																		</table>
																		";
				
				$qdf="SELECT *
										FROM $db_pfakturapproval
										WHERE nomorpesanan='".$dord['nomorpesanan']."'
																AND sesipesanan='".$dord['sesipesanan']."'
										";
				$rdf=mysqli_query($dbConnection, $qdf);
				$ddf=mysqli_fetch_array($rdf);
				$datafaktur="<table border='0' cellspacing='0' cellpadding='0' width='100%'>
																		<tr>
																			<td align='left' valign='middle' width='100%' style='line-height:25px; padding-bottom:10px'>
																				<b>Nama Lengkap</b><br>
																				".strtoupper($dord['namalengkap'])."
																			</td>	
																		</tr>
																		<tr>
																			<td align='left' valign='middle' width='100%' style='line-height:25px; padding-bottom:10px'>
																				<b>No. KTP</b><br>
																				<input type='text' name='noktp' value='".$dord['noktp']."' style='width:100%; padding:5px; text-transform:uppercase'>
																			</td>	
																		</tr>
																		<tr>
																			<td align='left' valign='middle' width='100%' style='line-height:25px; padding-bottom:10px'>
																				<b>Foto KTP</b><br>
																				".$fotoktpf."
																			</td>	
																		</tr>
																		<tr>
																			<td align='left' valign='middle' width='100%' style='line-height:25px; padding-bottom:10px'>
																				<b>No. Kartu Keluarga</b><br>
																				<input type='text' name='nokk' value='".$dord['noktp']."' style='width:100%; padding:5px; text-transform:uppercase'>
																			</td>	
																		</tr>
																		<tr>
																			<td align='left' valign='middle' width='100%' style='line-height:25px; padding-bottom:10px'>
																				<b>Foto Kartu Keluarga</b><br>
																				<!-- <img src='https://api.digimaxoto.com/order/images/ktpfile/".$dord['fotoktp']."' style='width:300px; border:1px solid #acbccc; padding:1px; border-radius:10px'> -->
																			</td>	
																		</tr>
																		<tr>
																			<td align='left' valign='middle' width='100%' style='line-height:25px; padding-bottom:10px'>
																				<b>No. NPWP</b><br>
																				<input type='text' name='nokk' value='".$dord['noktp']."' style='width:100%; padding:5px; text-transform:uppercase'>
																			</td>	
																		</tr>
																		<tr>
																			<td align='left' valign='middle' width='100%' style='line-height:25px; padding-bottom:10px'>
																				<b>Foto NPWP</b><br>
																				<!-- <img src='https://api.digimaxoto.com/order/images/ktpfile/".$dord['fotoktp']."' style='width:300px; border:1px solid #acbccc; padding:1px; border-radius:10px'> -->
																			</td>	
																		</tr>
																	</table>
																	";

				$tandajadi="";
				$periksadata="-";
				$bayarlunas="-";
				$pengajuanfaktur="-";
				$pengiriman="-";
				$stnkbpkb="-";
				$batal="";
				
				$msg="<h1>NO. PESANAN ".$nomorpesanan."</h1>
										<span style='background-color:#ff0000; color:#ffffff; border-radius:5px; padding:8px 10px 8px'>
											<b>Status Terakhir: ".$statusterakhir."</b>
										</span>
										<br><br><br>
										<h2>CATATAN ADMIN</h2>
										<div style='width:100%; line-height:17px'>".$catatan."</div>
										<br><hr size='1'><br>
										<h2>DATA PRODUK</h2>
										<div style='width:100%; line-height:17px'>".$dataproduk."</div>
										<br><br><hr size='1'><br>
										<h2>PEMBAYARAN</h2>
										<div style='width:100%; line-height:17px'>".$datapembayaran."</div>
										<br><br><hr size='1'><br><br>
										<table border='0' cellpadding='0' cellspacing='0' width='100%'>
											<tr>
												<td align='left' valign='top' width='50%' style='padding-right:10px'>
													<h2>DATA PEMESAN</h2>
													".$datapesanan."
												</td>
												<td align='left' valign='top' width='50%' style='padding-left:10px'>
													<h2>DATA FAKTUR</h2>
													".$datafaktur."
												</td>
											</tr>
										</table>
										";
				}
		else
		{ $msg="<b>Data pesanan tidak ditemukan.</b><br><br>
										Biasanya terjadi karena status pesanan sudah berubah atau pesanan sudah dibatalkan.
										";
				}

		$content="<table border='0' cellpadding='0' cellspacing='0' width='100%' height='100%'>
													<tr>
														<td align='left' valign='top' width='100%' height='100%'>
															<b class='title'>LIHAT DATA PESANAN</b>
															<br><hr size='1' color='#000000'><br>
															<table border='0' cellpadding='0' cellspacing='0'>
																<tr>
																	<td align='left' valign='middle'>
																		<span class='material-icons'>arrow_circle_left</span> &nbsp;
																	</td>
																	<td align='left' valign='middle'>
																		".$linkback."
																	</td>
																</tr>
															</table>
															<br>
															".$msg."
														</td>
													</tr>
												</table>
												";
		}

include "webmenu.php";
include "common/include/template.php";
$temp=new template;
$temp->define_theme("themes/theme1.html");
$temp->define_tag("{PAGETITLE}", $namaaplikasi);
$temp->define_tag("{NAMAUSER}", strtoupper($_SESSION['SES_FULLNAME']));
$temp->define_tag("{APPMENU}", $webmenu);
$temp->define_tag("{APPCONTENT}", $content);
$temp->parse();
$temp->printproses();

closeDB();

?>