<?php

header("X-Content-Type-Options: nosniff");
header("X-XSS-Protection: 1; mode=block");
header("X-Frame-Options: DENY");
header('Expires: Sun, 01 Jan 2000 00:00:00 GMT');
header('Cache-Control: no-store, no-cache, must-revalidate');
header('Cache-Control: post-check=0, pre-check=0', FALSE);
header('Pragma: no-cache');

ini_set('session.cookie_httponly', 'on');
ini_set('session.cookie_secure', 'on');

session_name("SIGNADMAUTH");
session_start();

include "common/config/config.php";
include "common/config/dbconfig.php";
include "common/functions/funcconnect.php";
include "common/functions/funcauthen.php";
include "common/functions/funcvalidateinput.php";
openDB();

if (!authen())
{ header ("location: login.php");
		}
else
{ $idpesanan=isset($_GET['idp']) ? cleanval($_GET['idp']) : NULL;
		$nomorpesanan=isset($_GET['oid']) ? base64_decode(cleanval($_GET['oid'])) : NULL;
		$jumlahpesan=isset($_POST['jumlahpesan']) ? cleanval($_POST['jumlahpesan']) : NULL;
		$idmr=isset($_POST['idmr']) ? cleanval($_POST['idmr']) : NULL;
		$idmd=isset($_POST['idmd']) ? cleanval($_POST['idmd']) : NULL;
		$idw=isset($_POST['idw']) ? cleanval($_POST['idw']) : NULL;
		$idwl=isset($_POST['idwl']) ? cleanval($_POST['idwl']) : NULL;
		$ontr=isset($_POST['ontr']) ? cleanval($_POST['ontr']) : NULL;
		$idtp=isset($_POST['idtp']) ? cleanval($_POST['idtp']) : NULL;
		$jumlahdiskon=isset($_POST['jumlahdiskon']) ? cleanval($_POST['jumlahdiskon']) : NULL;
		$script="";
		
		// cek id dan nomor pesanan
		$qord="SELECT *
									FROM $db_pesanan
									WHERE idpesanan='".$idpesanan."'
															AND nomorpesanan='".$nomorpesanan."'
															AND statusorder<4
									";
		$rord=mysqli_query($dbConnection, $qord);
		if (mysqli_num_rows($rord)>0)
		{ $dord=mysqli_fetch_array($rord);
				$qup="UPDATE $db_pdetailapproval
										SET tolaktgl='".$wktsekarangdb."',
														tolakoleh='OTOMATIS',
														tolaksebab='BATAL UBAH'
										WHERE nomorpesanan='".$dord['nomorpesanan']."'
																AND sesipesanan='".$dord['sesipesanan']."'
																AND tolaktgl IS NULL
										";
				$rup=mysqli_query($dbConnection, $qup);
				if ($rup)
				{ // ini bisa lebih dari 1 (satu) item !!
						$totalharga=0;
						$qip="SELECT a.iditem,
																			b.kodekategoribarang, b.namakategoribarang,
																			c.kodemerek, c.namamerek,
																			d.kodemodel, d.namamodel,
																			e.kodewarna, e.namawarna, e.kodehtml,
																			f.thnproduksi,
																			g.iditemprice, g.ontheroad, g.hargajual,
																			h.namawilayahotr
												FROM $db_item a
												INNER JOIN $db_kategoribarang b ON a.idkategoribarang=b.idkategoribarang
												INNER JOIN $db_merek c ON a.idmerek=c.idmerek
												INNER JOIN $db_model d ON a.idmodel=d.idmodel
												INNER JOIN $db_warna e ON a.idwarna=e.idwarna
												INNER JOIN $db_thnproduksi f ON a.idthnproduksi=f.idthnproduksi
												INNER JOIN $db_itemprice g ON d.idmodel=g.idmodel
												INNER JOIN $db_wilayahotr h ON g.idwilayahotr=h.idwilayahotr
												WHERE c.idmerek='".$idmr."'
																		AND d.idmodel='".$idmd."'
																		AND e.idwarna='".$idw."'
																		AND f.idthnproduksi='".$idtp."'
																		AND g.ontheroad='".$ontr."'
																		AND h.idwilayahotr='".$idwl."'
																		AND a.tersedia='1'
																		AND b.tersedia='1'
																		AND c.tersedia='1'
																		AND d.tersedia='1'
																		AND f.tersedia='1'
												ORDER BY a.iditem,
																					b.idkategoribarang, 
																					c.idmerek, 
																					d.idmodel, 
																					g.idwilayahotr,
																					f.idthnproduksi,
																					e.namawarna
																					ASC
													";
						$rip=mysqli_query($dbConnection, $qip);
						// echo $qip."<br><br>";
						// exit;
						$dip=mysqli_fetch_array($rip);
						if (empty($dip['ontheroad']))
						{ $ontrharga="Off-the-Road ";
								}
						else
						{ $ontrharga="On-the-Road ";
								}
						$subtotal=$jumlahpesan*($dip['hargajual']-$jumlahdiskon);
						$totalharga=$totalharga+$subtotal;
						$qidp="INSERT INTO $db_pdetailapproval (nomorpesanan,
																																														sesipesanan,
																																														idrekanan,
																																														idtoko,
																																														iditem,
																																														iditemprice,
																																														jumlahpesan,
																																														hargajual,
																																														subtotal,
																																														jumlahdiskon,
																																														mintatgl,
																																														mintaoleh)
													VALUES ('".$dord['nomorpesanan']."',
																					'".$dord['sesipesanan']."',
																					'".$dord['idrekanan']."',
																					'".$dord['idtoko']."',
																					'".$dip['iditem']."',
																					'".$dip['iditemprice']."',
																					'".$jumlahpesan."',
																					'".$dip['hargajual']."',
																					'".$subtotal."',
																					'".$jumlahdiskon."',
																					'".$wktsekarangdb."',
																					'".$_SESSION['SES_USERNAME']."')
													";
						$ridp=mysqli_query($dbConnection, $qidp);
						if ($ridp)
						{ $catatan="Mengubah data produk yang dipesan.";
								$qic="INSERT INTO $db_pesanannote (nomorpesanan,
																																											sesipesanan,
																																											idrekanan,
																																											idtoko,
																																											statusorder,
																																											catatan,
																																											catattgl,
																																											catatoleh)
														VALUES ('".$dord['nomorpesanan']."',
																						'".$dord['sesipesanan']."',
																						'".$dord['idrekanan']."',
																						'".$dord['idtoko']."',
																						'".$dord['statusorder']."',
																						'".$catatan."',
																						'".$wktsekarangdb."',
																						'".$_SESSION['SES_USERNAME']."')
														";
								$ric=mysqli_query($dbConnection, $qic);
								$msg="Sukses menyimpan perubahan data produk.";
								$script.="<script>
																			var goBack = function ()
																																{ setTimeout(function()
																																													{ window.location='konfirmasidata.php?idp=".$dord['idpesanan']."&oid=".base64_encode($dord['nomorpesanan'])."';
																																															}, 
																																													1000);
																																		};
																			window.onload = goBack();
																		</script>
																		";
								}
						else
						{ $msg="Gagal menyimpan perubahan data produk.<br><br>".$linkback;
								}
						}
				else
				{ $msg="Gagal membatalkan perubahan data produk sebelumnya.<br><br>".$linkback;
						// $msg.="<br><br>".$qup.mysqli_error($dbConnection);
						}
				}
		else
		{ $msg="Data pesanan tidak ditemukan.<br><br>
										Biasanya terjadi karena proses konfirmasi data sudah terlewati atau pesanan sudah dibatalkan.<br><br>".$linkback;
				}

		$content=$script.
											"<table border='0' cellpadding='0' cellspacing='0' width='100%' height='100%'>
													<tr>
														<td align='left' valign='top' width='100%' height='100%'>
															<b class='title'>KONFIRMASI DATA &gt; UBAH PRODUK</b>
															<br><hr size='1' color='#000000'><br>
															".$msg."
														</td>
													</tr>
												</table>
												";
		}

include "webmenu.php";
include "common/include/template.php";
$temp=new template;
$temp->define_theme("themes/theme1.html");
$temp->define_tag("{PAGETITLE}", $namaaplikasi);
$temp->define_tag("{NAMAUSER}", strtoupper($_SESSION['SES_FULLNAME']));
$temp->define_tag("{APPMENU}", $webmenu);
$temp->define_tag("{APPCONTENT}", $content);
$temp->parse();
$temp->printproses();

closeDB();

?>