<?php

header("X-Content-Type-Options: nosniff");
header("X-XSS-Protection: 1; mode=block");
header("X-Frame-Options: DENY");
header('Expires: Sun, 01 Jan 2000 00:00:00 GMT');
header('Cache-Control: no-store, no-cache, must-revalidate');
header('Cache-Control: post-check=0, pre-check=0', FALSE);
header('Pragma: no-cache');

ini_set('session.cookie_httponly', 'on');
ini_set('session.cookie_secure', 'on');

session_name("DOTOADMSPR");
session_start();

include "common/config/config.php";
include "common/config/dbconfig.php";
include "common/functions/funcconnect.php";
include "common/functions/funcauthen.php";
openDB();

if (!authen())
{ header ("location: login.php");
		}
else
{ $qord="SELECT j.*,
																i.*,
																a.iditem,
																b.kodekategoribarang, b.namakategoribarang,
																c.kodemerek, c.namamerek,
																d.kodemodel, d.namamodel,
																e.kodewarna, e.namawarna, e.kodehtml,
																f.thnproduksi,
																g.iditemprice, g.ontheroad,
																h.namawilayahotr,
																l.namacarabayartandajadi,
																IF (j.catatan IS NOT NULL AND j.catatan<>'',j.catatan,'-') AS ordernote,
																IF (j.statustandajadi=1,'Sukses','Gagal') AS statusbayardp
									FROM $db_pesanan j
									INNER JOIN $db_toko k ON j.idtoko=k.idtoko 
									INNER JOIN $db_pesanandetail i ON j.sesipesanan=i.sesipesanan
									INNER JOIN $db_item a ON i.iditem=a.iditem
									INNER JOIN $db_carabayartandajadi l ON j.idcarabayartandajadi=l.idcarabayartandajadi
									INNER JOIN $db_kategoribarang b ON a.idkategoribarang=b.idkategoribarang
									INNER JOIN $db_merek c ON a.idmerek=c.idmerek
									INNER JOIN $db_model d ON a.idmodel=d.idmodel
									INNER JOIN $db_warna e ON a.idwarna=e.idwarna
									INNER JOIN $db_thnproduksi f ON a.idthnproduksi=f.idthnproduksi
									INNER JOIN $db_itemprice g ON d.idmodel=g.idmodel AND i.iditemprice=g.iditemprice
									INNER JOIN $db_wilayahotr h ON g.idwilayahotr=h.idwilayahotr
									WHERE j.statustandajadi='1'
															AND j.statusorder<>'8'
									ORDER BY j.idpesanan DESC
									";
		$rord=mysqli_query($dbConnection, $qord);
		// echo $qord."<br><br>".mysqli_error($dbConnection)."<br><br>";
		$totalrow=mysqli_num_rows($rord);
		if ($totalrow>0)
		{ $allorder="";
				while ($dord=mysqli_fetch_array($rord))
				{ if (empty($dord['ontheroad']))
						{ $ontrharga="OFF-THE-ROAD ";
								}
						else
						{ $ontrharga="ON-THE-ROAD ";
								}
						$action="<table border='0' cellpadding='0' cellspacing='0'>
																<tr style='background-color:rgba(0, 0, 0, 0)'>
																	<td align='left' valign='top' style='all:revert; padding-right:5px'>
																		<span class='material-icons-outlined'>3p</span>
																	</td>
																	<td align='left' valign='top' style='all:revert; font-size:8pt' nowrap>
																		<a href='konfirmasidata.php?idp=".$dord['idpesanan']."&oid=".base64_encode($dord['nomorpesanan'])."'>Periksa Data</a>
																	</td>
																</tr>	
															</table>
															";
						$allorder.="<tr>
																			<td align='left' valign='top' nowrap>
																				".date("d-m-Y H:i:s", strtotime($dord['waktutandajadi']))."<br>
																				No.: ".$dord['nomorpesanan']."
																			</td>
																			<td align='left' valign='top'>
																				".strtoupper($dord['namalengkap'])."<br>
																				".$dord['noktp']."<br>
																				".strtoupper($dord['alamatlengkap'])."<br>
																				".$dord['nohandphone']."<br>
																			</td>
																			<td align='left' valign='top'>
																				".$dord['jumlahpesan']." UNIT ".strtoupper($dord['namamerek'])." ".strtoupper($dord['namamodel'])."<br>
																				".strtoupper($dord['namawarna'])." THN ".$dord['thnproduksi']."<br>
																				".$ontrharga." ".strtoupper($dord['namawilayahotr'])."<br>
																				Rp. ".number_format($dord['hargajual'], 0, ",", ".")."
																			</td>
																			<td align='left' valign='top' nowrap>
																				Rp. ".number_format($dord['totaltandajadi'], 0, ",", ".")."<br>
																				".$dord['namacarabayartandajadi']."<br>
																				".date("d-m-Y H:i:s", strtotime($dord['waktutandajadi']))."<br>
																				".strtoupper($dord['statusbayardp'])."
																			</td>
																			<td align='left' valign='top' nowrap>
																				".strtoupper($dord['ordernote'])."
																			</td>
																			<td align='left' valign='top' nowrap>
																				".$action."
																			</td>
																		</tr>
																		";
						}
				}
		else
		{ $allorder="<tr>
																<td align='center' valign='center' colspan='5' height='50px'>
																	Tidak ada pesanan yang belum diproses
																</td>
															</tr>
															";
				}
		$content="<table border='0' cellpadding='0' cellspacing='0' width='100%'>
													<tr>
														<td align='left' valign='top' width='100%'>
															<!--
															<div style='border:2px solid #ffaaaa; padding:10px; background-color:#ffefef; line-height:18px; font-weight:bold; font-size:10pt'>
																Semua data dan informasi bersifat sangat rahasia oleh karena itu menyalinnya, 
																menyimpannya, atau membagikannya dengan lalai dan/atau tanpa izin akan diproses sesuai aturan
																yang berlaku di DigimaxOTO dan hukum serta undang-undang yang berlaku di negara Republik Indonesia.
															</div>	
															<br><br>
															-->
															<b class='title'>PESANAN BELUM SELESAI</b>
															<br><hr size='1' color='#000000'><br>
															<table border='0' cellpadding='0' cellspacing='0' width='100%'>
																<tr>
																	<td align='left' valign='top' width='100%'>
																		<table id='' class='display'>
																			<thead>
																				<tr>
																					<th align='center' valign='middle' nowrap>
																						<b>Pesanan</b>
																					</th>
																					<th align='center' valign='middle' width='22%' nowrap>
																						<b>Pembeli</b>
																					</th>
																					<th align='center' valign='middle' width='20%' nowrap>
																						<b>Produk Dipesan</b>
																					</th>
																					<th align='center' valign='middle' nowrap>
																						<b>Tanda Jadi</b>
																					</th>
																					<th align='center' valign='middle' width='15%' nowrap>
																						<b>Catatan</b>
																					</th>
																					<th align='center' valign='middle' nowrap>
																						<b>Tindakan</b>
																					</th>
																				</tr>
																			</thead>
																			<tbody>	
																				".$allorder."
																			</tbody>	
																		</table>
																	</td>
																</tr>
															</table>
														</td>
													</tr>
												</table>
												";
		}

include "webmenu.php";
include "common/include/template.php";
$temp=new template;
$temp->define_theme("themes/theme1.html");
$temp->define_tag("{PAGETITLE}", $namaaplikasi);
$temp->define_tag("{NAMAUSER}", strtoupper($_SESSION['SES_FULLNAME']));
$temp->define_tag("{APPMENU}", $webmenu);
$temp->define_tag("{APPCONTENT}", $content);
$temp->parse();
$temp->printproses();

closeDB();

?>