<?php

//SESSION
session_name("SIGNADMAUTH");
session_start();

//INCLUDE
include "common/config/config.php";
include "common/config/dbconfig.php";
include "common/functions/funcconnect.php";
openDB();

include "common/functions/funcauthen.php";
include "common/functions/funcselectdb.php";
include "common/functions/funcinsertdb.php";

//------------------------------------------------------------------------------------------------------------------------

//MAIN CONDITION
if (!authen())
{
    header("location: login.php");
}
else if (!fullaccess($_GET['menuid'], $_SESSION['SES_GROUPID']))
{
    header("location: index.php");
}
else
{
   $groupModel=$_POST['groupModel_add'];
   $kodeModel=$_POST['kodeModel_add'];
   $namaModel=$_POST['namaModel_add'];
   $spesifikasi=$_POST['spesifikasi_add'];
   $statusTersedia=$_POST['status_add'];

   if (empty($groupModel))
    {
        $msg="Group Model tidak boleh kosong.<br><br>".$linkback;
    }
    else if (empty($kodeModel))
    {
        $msg="Kode Model tidak boleh kosong.<br><br>".$linkback;
    }
    else if (empty($namaModel))
    {
        $msg="Nama Model tidak boleh kosong.<br><br>".$linkback;
    }
    else if (empty($spesifikasi))
    {
        $msg="Spesifikasi tidak boleh kosong.<br><br>".$linkback;
    }
    else if (empty($statusTersedia))
    {
        $msg="Status tidak boleh kosong.<br><br>".$linkback;
    }
    else
    {
        $qmap="INSERT INTO $db_model (groupmodel, kodemodel, namamodel, spesifikasi, tersedia) ";
        $qmap.="VALUES ('".mysqli_real_escape_string($dbConnection, $groupModel)."', '".mysqli_real_escape_string($dbConnection, $kodeModel)."', '".mysqli_real_escape_string($dbConnection, $namaModel)."', '".mysqli_real_escape_string($dbConnection, $spesifikasi)."', '".mysqli_real_escape_string($dbConnection, $statusTersedia)."') ";
        $rmap=mysqli_query($dbConnection, $qmap);

        //sub-condition
        if ($rmap)
        {
            $msg="Menambah Model Produk sukses.<br><br>".$linkback;
            $logdesc="TAMBAH MODEL PRODUK";
            include "logakses.php";
        }
        else
        {
            $msg="Menambah Model Produk gagal.<br><br>".$linkback;
        }
    }

    //------------------------------------------------------------------------------------------------------------------------------------------------------------

    //QUERY APP MENU
    $qq="SELECT a.appmenuname, b.parentmenuname FROM $db_appmenu a, $db_parent_menu b ";
	$qq.="WHERE a.appmenuid='".mysqli_real_escape_string($dbConnection, $_GET['menuid'])."' AND b.parentmenuid=a.parentid";
	$rr=mysqli_query($dbConnection, $qq);
	$dd=mysqli_fetch_array($rr);

    //CONTENT
    $content="<table border='0' cellpadding='6px' cellspacing='0' width='100%'>
                    <tr>
                        <td align='left' valign='top' width='100%'>
                            <b class='title'>".$dd['parentmenuname']." &gt; ".$dd['appmenuname']."</b>
                            <br><hr size='1' color='#000000'><br>

                            <table border='0' cellpadding='0' cellspacing='0'>
                                <tr>
                                    <td align='left' valign='top' width='50%'>
                                        ".$msg."
                                    </td>
                                </tr>
                            </table>

                        </td>
                    </tr>
            </table>";
}

//------------------------------------------------------------------------------------------------------------------------------------------------------------

//TEMPLATE
include "webmenu.php";
include "common/include/template.php";
$temp=new template;
$temp->define_theme("themes/theme1.html");
$temp->define_tag("{PAGETITLE}", $namaaplikasi);
$temp->define_tag("{NAMAUSER}", strtoupper($_SESSION['SES_FULLNAME']));
$temp->define_tag("{APPMENU}", $webmenu);
$temp->define_tag("{APPCONTENT}", $content);
$temp->parse();
$temp->printproses();

closeDB();

?>