<?php

session_name("SIGNADMAUTH");
session_start();

include "common/config/config.php";
include "common/config/dbconfig.php";
include "common/functions/funcconnect.php";
openDB();

include "common/functions/funcauthen.php";
include "common/functions/funcselectdb.php";
include "common/style/styleRekanan.css";

//----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

//MAIN CONDITION
if (!authen())
{
    header("location: login.php");
}
else
{
    //QUERY SQL
    // $rm="SELECT a.*, b.* FROM $db_rekanan a, $db_propinsi b WHERE b.idpropinsi=a.idpropinsi";

    $rm="SELECT a.*, b.*, c.* FROM $db_rekanan a
        JOIN $db_kota b ON a.idkota=b.idkota
        JOIN $db_propinsi c ON a.idpropinsi=c.idpropinsi";

    $connect=mysqli_query($dbConnection, $rm);
    //  echo $connect."<br>".mysqli_error($dbConnection); exit; //cek query err
    $dataTaken=mysqli_num_rows($connect);


    //CONDITION
    if (mysqli_num_rows($connect)>0)
    {
        $count=1;
        $rekananList="";

        //data looping
        while ($loopRekanan=mysqli_fetch_array($connect))
        {
            //sub-condition 1 (0=tidak di suspend 1=di suspend)
            if ($loopRekanan['statussuspend']==1)
            {
                $statusSuspend="Di Suspend";
            }
            else
            {
                $statusSuspend="Tidak di Suspend";
            }

            //sub-condition 2 (0=tidak di suspend 1=di suspend)
            if ($loopRekanan['statusnonaktif']==1)
            {
                $statusAktif="Non-Aktif";
            }
            else
            {
                $statusAktif="Aktif";
            }


            //LIST VAR FIELD (value take from db)
            $rekananList.="<tr>
                                <td align='center' valign='top' nowrap>
                                    <b>".$count++."</b>
                                </td>
                                <td align='left' valign='top' nowrap>
                                    ".$loopRekanan['namarekanan']."
                                </td>
                                <td align='center' valign='top' nowrap>
                                    ".$loopRekanan['koderekanan']."
                                </td>
                                <td align='center' valign='top' nowrap>
                                    ".$loopRekanan['pid']."
                                </td>
                                <td align='left' valign='top'>
                                    ".$loopRekanan['alamatrekanan']."
                                </td>
                                <td align='center' valign='top' nowrap>
                                    ".$loopRekanan['idkota']." -
                                    ".$loopRekanan['namakota']."
                                </td>
                                <td align='center' valign='top' nowrap>
                                    ".$loopRekanan['idpropinsi']." -
                                    ".$loopRekanan['namapropinsi']."
                                </td>
                                <td align='left' valign='top' nowrap>
                                    ".$loopRekanan['namalengkap']."
                                </td>
                                <td align='left' valign='top' nowrap>
                                    ".$loopRekanan['teleponrekanan']."
                                </td>
                                <td align='left' valign='top' nowrap>
                                    ".$loopRekanan['emailrekanan']."
                                </td>
                                <td align='center' valign='top' nowrap>
                                    ".$loopRekanan['tglinput']."
                                </td>
                                <td align='center' valign='top' nowrap>
                                    $statusSuspend
                                </td>
                                <td align='center' valign='top' nowrap>
                                    $statusAktif
                                </td>";

                    //EDIT BUTTON
                    if (fullaccess($_GET['menuid'], $_SESSION['SES_GROUPID']) || editaccess($_GET['menuid'], $_SESSION['SES_GROUPID']))
                    {
                    $rekananList.="<td align='center' valign='top'>
                                        <a href='rekanan_edit.php?id=".$loopRekanan['idrekanan']."&menuid=".$_GET['menuid']."'><img src='images/database_edit.png' align='absmiddle' title='Edit'></a>
                                    </td>";  
                    }
                    else
                    {
                        $rekananList.="<td></td>";
                    }

                    //DELETE BUTTON
                    if (fullaccess($_GET['menuid'], $_SESSION['SES_GROUPID']) || deleteaccess($_GET['menuid'], $_SESSION['SES_GROUPID']))
                    {
                    $rekananList.="<td align='center' valign='top'>
                                        <a href='rekanan_delete.php?id=".$loopRekanan['idrekanan']."&menuid=".$_GET['menuid']."'><img src='images/database_delete.png' align='absmiddle' title='Hapus'></a>
                                    </td>";
                    }
                    else
                    {
                        $rekananList.="<td></td>";
                    }
            $rekananList.="<td></td>";
        }
    }
    else
    {
        $modelList="<tr>
                        <td>
                            <b>Data Rekanan tidak ditemukan.</b>
                        </td>
                    </tr>";
    }

    //----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

    //QUERY APP MENU
    $qq="SELECT a.appmenuname, b.parentmenuname FROM $db_appmenu a, $db_parent_menu b ";
    $qq.="WHERE a.appmenuid='".mysqli_real_escape_string($dbConnection, $_GET['menuid'])."' AND b.parentmenuid=a.parentid";
    $rr=mysqli_query($dbConnection, $qq);
    $dd=mysqli_fetch_array($rr);

    //CONTENT
    $content="<table border='0' cellpadding='6px' cellspacing='0' widht='100%'>
                    <tr>
                        <td align='left' valign='top' width='100%'>
                            <b class='title'>".$dd['parentmenuname']." &gt; ".$dd['appmenuname']."</b>
                            <br><hr size='1' color='#000000'></br>

                            <table border='0' cellpadding='0' cellspacing='0'>
                                <tr>
                                    <td align='left' valign='top'>";

                                        //ADD BUTTON
                                        if (fullaccess($_GET['menuid'], $_SESSION['SES_GROUPID']) || addaccess($_GET['menuid'], $_SESSION['SES_GROUPID']))
                                        {
                                           $content.="<input type='button' value=' [+] Tambah Rekanan' onclick=\"document.location='rekanan_add.php?menuid=".$_GET['menuid']."'\"><br><br>"; 
                                        }

                                        //MAIN CONTENT
                                        $content.="<table id='' class='display' style='border: 1px solid; background-color: #4ecf71;'>
                                                        <thead>
                                                            <tr>
                                                                <th align='center' valign='middle' width='100%' nowrap>
                                                                    <b>No</b>
                                                                </th>
                                                                <th align='left' valign='middle' width='100%' nowrap>
                                                                    <b>Nama Rekanan</b>
                                                                </th>
                                                                <th align='center' valign='middle' width='100%' nowrap>
                                                                    <b>Kode Rekanan</b>
                                                                </th>
                                                                <th align='center' valign='middle' width='100%' nowrap>
                                                                    <b>PID</b>
                                                                </th>
                                                                <th align='center' valign='middle' width='100%' nowrap>
                                                                    <b>Alamat Rekanan</b>
                                                                </th>
                                                                <th align='center' valign='middle' width='100%' nowrap>
                                                                    <b>ID Kota</b>
                                                                </th>
                                                                <th align='center' valign='middle' width='100%' nowrap>
                                                                    <b>ID Propinsi</b>
                                                                </th>
                                                                <th align='center' valign='middle' width='100%' nowrap>
                                                                    <b>Nama Lengkap</b>
                                                                </th>
                                                                <th align='center' valign='middle' width='100%' nowrap>
                                                                    <b>Telepon Rekanan</b>
                                                                </th>
                                                                <th align='center' valign='middle' width='100%' nowrap>
                                                                    <b>Email Rekanan</b>
                                                                </th>
                                                                <th align='center' valign='middle' width='100%' nowrap>
                                                                    <b>Tanggal Input</b>
                                                                </th>
                                                                <th align='center' valign='middle' width='100%' nowrap>
                                                                    <b>Status Suspend</b>
                                                                </th>
                                                                <th align='center' valign='middle' width='100%' nowrap>
                                                                    <b>Status Aktif</b>
                                                                </th>
                                                            
                                                                <th align='center' valign='middle' width='100%' nowrap>
                                                                    <b>Edit</b>
                                                                </th>
                                                                <th align='center' valign='middle' width='100%' nowrap>
                                                                    <b>Hapus</b>
                                                                </th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            ".$rekananList."
                                                        </tbody>
                                                    </table>
                                    </td>
                                </tr>
                            </table>
                        
                        </td>
                    </tr>
                </table>";
}

//----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

//TEMPLATE
include "webmenu.php";
include "common/include/template.php";
$temp=new template;
$temp->define_theme("themes/theme1.html");
$temp->define_tag("{PAGETITLE}", $namaaplikasi);
$temp->define_tag("{NAMAUSER}", strtoupper($_SESSION['SES_FULLNAME']));
$temp->define_tag("{APPMENU}", $webmenu);
$temp->define_tag("{APPCONTENT}", $content);
$temp->parse();
$temp->printproses();

closeDB();

?>